import os
import json

def get_sr(results):
    res = []
    for sample_id, response in results.items():
        gt = response['gt']
        response_text = response['response']["content"]
        res.append(gt == response_text)
    
    stat = {
        "SR": sum(res) / len(res),
        "Total": len(res),
    }
    return stat

files = os.listdir("llm_output")
for file in files:
    file_path = os.path.join("llm_output", file)
    with open(file_path, 'r') as f:
        results = json.load(f)
    
    stats = get_sr(results)
    print(f"File: {file}, SR: {stats['SR']:.4f}, Total: {stats['Total']}")
    
    
    